
%%
%%  This is file `Shahrood_thesis.cls',
%%  The original file was xepersian-thesis.cls by Vafa Khalighi
%%   __________________________________
%%   Customized for Shahrood University of Technology By Ali Mesforush
%%   Copyright © 2012-2016 Ali Mesforush
%%  
%%   http://www.parsilatex.com  
%%   http://forum.parsilatex.com
%% 
%% \vtitle
\NeedsTeXFormat{LaTeX2e}
\ProvidesClass{Shahrood_thesis}
              [08/04/2012 v0.4
 Persian thesis document class in XeLaTeX for Shahrood University projects/theses/dissertations]
\DeclareOption*{\PassOptionsToClass{\CurrentOption}{book}}
\ProcessOptions
\LoadClass[a4paper,12pt,twoside]{book}
\def\university#1{\gdef\@university{#1}}
\def\department#1{\gdef\@department{#1}}
\def\degree#1{\gdef\@degree{#1}}
\def\thesisdate#1{\gdef\@thesisdate{#1}}
\newcommand{\firstsupervisor}[1]{\def\@firstsupervisor{#1}}
\newcommand{\secondsupervisor}[1]{\def\@secondsupervisor{#1}}
\newcommand{\firstadvisor}[1]{\def\@firstadvisor{#1}}
\newcommand{\secondadvisor}[1]{\def\@secondadvisor{#1}}
\def\name#1{\gdef\@name{#1}}
\def\surname#1{\gdef\@surname{#1}}

\def\stuNO#1{\gdef\@stuNO{#1}}


\def\keywords#1{\gdef\@keywords{#1}}
\def\fa-abstract#1{\gdef\@fa-abstract{#1}}
\def\faculty#1{\gdef\@faculty{#1}}
\def\subject#1{\gdef\@subject{#1}}
\def\field#1{\gdef\@field{#1}}
\def\department#1{\gdef\@department{#1}}
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
\def\latintitle#1{\gdef\@latintitle{#1}}
\def\latinauthor#1{\gdef\@latinauthor{#1}}
\def\latindegree#1{\gdef\@latindegree{#1}}
\def\latinfaculty#1{\gdef\@latinfaculty{#1}}
\def\latinthesisdate#1{\gdef\@latinthesisdate{#1}}
\def\latinsubject#1{\gdef\@latinsubject{#1}}
\def\latinfield#1{\gdef\@latinfield{#1}}
\def\firstlatinsupervisor#1{\gdef\@firstlatinsupervisor{#1}}
\def\secondlatinsupervisor#1{\gdef\@secondlatinsupervisor{#1}}
\def\firstlatinadvisor#1{\gdef\@firstlatinadvisor{#1}}
\def\secondlatinadvisor#1{\gdef\@secondlatinadvisor{#1}}
\def\latinname#1{\gdef\@latinname{#1}}
\def\latinsurname#1{\gdef\@latinsurname{#1}}
\def\en-abstract#1{\gdef\@en-abstract{#1}}
\def\latinkeywords#1{\gdef\@latinkeywords{#1}}
\def\latinuniversity#1{\gdef\@latinuniversity{#1}}
%%%%%%%%%%%%%%%%%%%%%%%%%%%
\newif\if@bscthesis
\@bscthesisfalse
\DeclareOption{bsc}{\@bscthesistrue}
\newif\if@mscthesis
\@mscthesisfalse
\DeclareOption{msc}{\@mscthesistrue}
\newif\if@prop
\@propfalse
\DeclareOption{prop}{\@proptrue}
\ProcessOptions
%%%%%%%%%%%%%%%%%%%%%%%%%%%
\newcommand{\vtitle}{\begin{titlepage}
%\topmargin=-30pt
\vspace{-1cm}\centerline{{\includegraphics[height=4.3cm,width=2.4cm]{images/Logo}}}
\vspace{.2cm}
%{\large\@faculty\par
\vspace{-0.6cm} \bfseries دانشکده \@faculty%}
%\vskip .2cm

%\vskip -.2cm
%{\large\bfseries{ رشته}}
%\large \bfseries\@subject%
%\if@mscthesis%
%، گرایش
%\else
%\if@bscthesis%
%\relax%
%\else%
%، گرایش
%\fi\fi
%\@field

\vspace*{-0.7cm}

 \if@mscthesis
 {\large\bfseries پایان‌نامه کارشناسی ارشد \@field }
 \else
 \if@bscthesis
 {\large\bfseries   پروژه کارشناسی  }
 \else
  \if@prop
 {\large\bfseries   پیشنهاد رساله دکتری \@field }
 \else
 {\large\bfseries رساله دکتری \@field  }
 \fi\fi
 \vskip .15cm

\vskip 0.3cm
\baselineskip=.750cm
%\centerline{\Large \bfseries\onvan}

\vskip .2cm
%\centerline{ \bfseries عنوان}
\vskip 0.5cm
 {\huge\bfseries {\baselineskip=0cm \@title}}\baselineskip=0cm\par
\vskip 1cm
 \baselineskip=.5cm
\vspace{7.5mm}
\centerline{  \Large\textbf{نگارنده}:
 {\Large\bfseries\large\bfseries   \@name\ \@surname}}
 
 
\large
{\ifx\@firstsupervisor\undefined%
\ifx\@secondsupervisor\undefined%
\else\fi
\else
\ifx\@secondsupervisor\undefined%
استاد راهنما
\vspace{-1cm}
{\Large\bfseries\par
\textbf{دکتر} \@firstsupervisor}
\else
\large
استادان راهنما
\par
{\Large\bfseries \textbf{دکتر} \@firstsupervisor{} \\ \textbf{دکتر} \@secondsupervisor}
\fi\fi}
\par\large
{\ifx\@firstadvisor\undefined%
\ifx\@secondadvisor\undefined%
\else\fi
\else
\ifx\@secondadvisor\undefined%
استاد مشاور
\vspace{-1cm}
{\Large\bfseries\par
\textbf{دکتر} \@firstadvisor}
\else

\large
استادان مشاور
\par
{\Large\bfseries \textbf{دکتر} \@firstadvisor{}\\\textbf{ دکتر} \@secondadvisor}
\fi\fi}

%{\large%
 % \by}\par
  
  
\par
%{\Large\bfseries{\nastaliq\large\bfseries   \@name\ \ \@surname}}\par
\vskip 6mm
%\vfill
{\large \@thesisdate}
%\vfill
\end{titlepage}%
\newpage
\thispagestyle{empty}
\baselineskip=.7cm
\if@bscthesis \relax
\fi
}
\def\frame{\newpage
\thispagestyle{empty}
\begin{framed}\thispagestyle{empty}}
\def\endframe{\thispagestyle{empty}\end{framed}
\thispagestyle{empty}
\newpage
}
\def\abstractpage{\newpage
\thispagestyle{empty}
\vskip 15mm
\par
\begin{abstract}}
\def\endabstractpage{\end{abstract}
\newpage
}

\def\latinabstract{\newpage
\thispagestyle{empty}
\vskip 15mm
\begin{center}{\Large\bfseries \@latintitle \\[5mm]}
{\bfseries Abstract}
\end{center}
\vspace{5mm}}

\def\endlatinabstract{\newpage}

\def\acknowledgementpage{\newpage
\thispagestyle{plain}

\vspace{1cm}
\par\noindent}
\def\endacknowledgementpage{\newpage}

\def\titlepage{\newpage\centering
  \thispagestyle{empty}
  \parindent 0pt \parskip 10pt plus 1fil minus 1fil
  \def\baselinestretch{1}\@normalsize\vbox to \vsize\bgroup\vbox to 9in\bgroup}
\def\endtitlepage{\par\kern 0pt\egroup\vss\egroup\newpage}

\def\signature{\vspace{1cm}
\begin{flushleft}
{\bf  \@name\ \@surname \\
\@thesisdate}
\end{flushleft}}

\def\me{\@name\ \@surname\ }

\def\stNO{\@stuNO\ }

\def\reshteh{\@subject\ }
\def\daneshkadeh{\@faculty\ }
\def\onvapa{\@title\ }
\def\ostadaval{\@firstsupervisor\ }
\def\ostaddovom{\@secondsupervisor\ }

\def\ostadmoshaval{\@firstadvisor\ }
\def\ostadmoshdovom{\@secondadvisor\ }


\def\abstract{\subsection*{\abstractname}\small
\@normalsize}
\def\endabstract{\par}


\font\titlefont=cmssbx10 scaled 2074
\font\supervisorfont=cmbxti10

\newcommand{\latinvtitle}{%
\begin{titlepage}
\vspace{-1cm}
\begin{center}{\includegraphics[height=3.3cm,width=5cm]{images/logoen}}
\end{center}
%\centerline{\Large \bf\@latinuniversity} 
\large\bfseries
\vskip 3mm
\centerline{\@latinfaculty\space} 
\vskip 3mm

\if@mscthesis
{\large\bfseries MSc Thesis in \@latinfield }
\else
\if@bscthesis
{\large\bfseries BSc Project in  \@latinfield  }
\else
{\large\bfseries PhD Thesis in \@latinfield }
\fi\fi

\vskip 2cm

\baselineskip=.750cm
{\titlefont \@latintitle}
\baselineskip=.750cm \par

\vskip 2cm

{\large  By: \@latinname \; \@latinsurname}\par

\vskip 1cm
\large
{\ifx\@firstlatinsupervisor\undefined%
\ifx\@secondlatinsupervisor\undefined%
\else\fi
\else
\ifx\@secondlatinsupervisor\undefined%
Supervisor:
{\Large\bfseries\par
\@firstlatinsupervisor}
\else
\Large
Supervisors:
\par
{\large\bfseries Dr. \@firstlatinsupervisor{} \\ Dr. \@secondlatinsupervisor}
\fi\fi}
\par
\large
{\ifx\@firstlatinadvisor\undefined%
\ifx\@secondlatinadvisor\undefined%
\else\fi
\else
\ifx\@secondlatinadvisor\undefined%
Advisor:
{\Large\bfseries\par
\@firstlatinadvisor}
\else

\Large
\vspace*{0.25cm}
Advisors:
\par
{\large\bfseries Dr. \@firstlatinadvisor{} \\
	Dr. \@secondlatinadvisor}
\fi\fi}
\vskip 5mm

\vskip 5mm

\par
\vskip 1cm

{\@latinthesisdate}
\par
\vskip 1cm

\par

\vfill
%
\end{titlepage}
}

\def\cleardoublepage{\clearpage\if@twoside \ifodd\c@page\else
\hbox{}
\thispagestyle{empty}
\newpage
\if@twocolumn\hbox{}\newpage\fi\fi\fi}

%% 
%% Copyright © 2012-2016  by Ali Mesforush     
%% 
%% Distributable under the LaTeX Project Public License,
%% version 1.3c or higher (your choice). The latest version of
%% this license is at: http://www.latex-project.org/lppl.txt
%% 
%% 
%% 
%% End of file `Shahrood_thesis.cls'.
\usepackage{titlesec}
\titleformat{\chapter}[display]   
{\normalfont\huge\bfseries}{\chaptertitlename\ \thechapter}{20pt}{\Huge}   
\titlespacing*{\chapter}{0pt}{50pt}{40pt}
